<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

 class DPage{

	/**
	 * 当前页
	 * @var integer
	 */
 
	private $_index;
 
	/**
	 * 当前url
	 * @var string
	 */

	private $_self;

	/**
	 * 总页数
	 * @var integer
	 */

	private $_page;

	/**
	 * 分页码
	 * @var array
	 */

	private $_list = array();

	/**
	 * 分页信息
	 * @var string
	 */ 

	private $_str;

	/**
	 * 信息
	 */
	private $_pagestr;

	private $_type;

	/**
	 * 参数
	 */
	public $totalpage = 10;

	public $param;

	public $getp='page';

	public $g = false;

	public $target = '_self';

	/*
	 * 私有参数
	 */
	private static $Pds;

	private $_getv;

	private $_suffix;

	private $count;

	public function setLimit($count)
	{
		$this->_index = empty($_GET[$this->getp]) ?  1 : (int)$_GET[$this->getp];

		$this->_suffix = DuoLam::$config['frame']['html_on'] == true ? '.' . DuoLam::$config['frame']['html'] : null;

		$this->count = $count;

		$offset = ($this->_index - 1) * $this->totalpage;

		return $offset .','. $this->totalpage;
	}

	public function show($route=null,$type=0){

		self::$Pds = DuoLam::$config['default']['getSign'];

		$url = empty($route) ? C .'/'. A  . '/' : $route . '/';

		$this->_self = DuoLam::path() . $url . $this->param;

		$this->_getv = $this->g == true ? null : $this->getp . self::$Pds;

		$this->_type = $type;

		$maxtotal = $this->count; 

		$this->_page = ceil($maxtotal/(int)$this->totalpage);

		$this->_str = '<div id="page"><a title="共有' . $maxtotal . '条记录">&nbsp;' . $maxtotal . '&nbsp;</a>';

		$this->_str .= '<a title="当前第'.$this->_index .'页，共' . $this->_page .'页">&nbsp;' . $this->_index . '/' . $this->_page . '&nbsp;</a>';

		return $this->_display();

	}

	private function _pagePre(){

		return $this->_index - 1;

	}

	private function _pageNext(){

		return $this->_index + 1;

	}
	
	private function _listPageToIndex(){

		$this->_pagestr['first']='';

		if($this->_index != 1){

			$this->_pagestr['first'] ='<a href="'.$this->_self . $this->_getv . '1'.$this->_suffix.'" title="转到首页" target="'.$this->target.'">&nbsp;1...&nbsp;</a>';

			$this->_pagestr['first'].= '<a href="'.$this->_self . $this->_getv. $this->_pagePre() . $this->_suffix . '" title="上一页" target="'.$this->target.'">&nbsp;« 上一页&nbsp;</a>';
		}

	}

	private function _listPageToPre(){

		$this-> _pagestr['last']='';

		if($this->_index != $this->_page){

			$this->_pagestr['last'] = '<a href="'.$this->_self . $this->_getv . $this->_pageNext() . $this->_suffix . '" title="下一页" target="'.$this->target.'">&nbsp;下一页 »&nbsp;</a>';

			$this->_pagestr['last'].= '<a href="'.$this->_self . $this->_getv . $this->_page . $this->_suffix . '" title="转到尾页" target="'.$this->target.'">&nbsp;...'.$this->_page.'&nbsp;</a>';

		}

	}
	
	private function _formatList(){
	
		if(10 >= $this->_page){

			$pagestart = 1;

			$pageend = $this->_page;

		}elseif(($this->_index - 3 -1 + 10) > $this->_page){

			$pagestart = $this->_page - 10 + 1;

			$pageend = $this->_page;

		}else{

			$pagestart = ($this->_index <= 3) ? 1 : $this->_index - 3;

			$pageend =($pagestart == 1) ? 10 : $pagestart + 10 - 1;

		}

		for($page = $pagestart; $page <= $pageend; $page++){

			$this->_list[$page] = '<a href='.$this->_self . $this->_getv . $page . $this->_suffix . " title='转到第{$page}页'  target='".$this->target."' class=\"pagelist\">&nbsp;".$page.'&nbsp;</a>';

		}

	}

	private function _listPage()
	{
		$this->_listPageToIndex();

		$this->_listPageToPre();

		$this->_formatList();

		$this->_pagestr['page']='';

		foreach($this->_list as $key => $val){

			$this->_pagestr['page'] .= ($key == $this->_index) ? "<a title='当前第{$key}页'><span>&nbsp;".$key.'&nbsp;</span></a>' : $val;

		}

		return $this->_str .= $this->_pagestr['first'] . $this->_pagestr['page'] . $this->_pagestr['last'] . "</div>";
	}

	private function _geteralFormat()
	{
		$this->_pagestr['geteral'] = ($this->_index == 1 or $this->_index < 0) ?
		
		"<a>首页</a> <a>上一页</a> " :

		'<a href="'.$this->_self . $this->_getv . '1'.$this->_suffix.'" title="转到首页" class="page" target="'.$this->target.'">首页</a>
		
		<a href="'.$this->_self . $this->_getv. $this->_pagePre() . $this->_suffix . '" title="上一页" class="page" target="'.$this->target.'">上一页</a> ';

		$this->_pagestr['geteral'] .= ($this->_index == $this->_page or $this->_index > $this->_page) ?

		" <a>下一页</a> <a>尾页</a>" : 

		 '<a href="'.$this->_self . $this->_getv . $this->_pageNext() . $this->_suffix . '" title="下一页" class="page" target="'.$this->target.'">下一页</a>
		
		<a href="'.$this->_self . $this->_getv . $this->_page . $this->_suffix . '" title="转到尾页" class="page" target="'.$this->target.'">尾页</a>';

	}

	private function _generalPage()
	{
		$this->_geteralFormat();

		return $this->_str .= $this->_pagestr['geteral'];
	}

	private function _display()
	{

		switch ($this->_type)
		{
			case 0 :
				return $this->_listPage();
				break;
			case 1 :
				return $this->_generalPage();
				break;
		}
		
	}

 }